<?php

namespace RalphJSmit\Packages;

use Composer\Composer;
use Composer\EventDispatcher\EventSubscriberInterface;
use Composer\IO\IOInterface;
use Composer\Plugin\PluginEvents;
use Composer\Plugin\PluginInterface;
use Composer\Plugin\PreFileDownloadEvent;

class Plugin implements PluginInterface, EventSubscriberInterface
{
    protected IOInterface $io;

    public function activate(Composer $composer, IOInterface $io): void
    {
        $this->io = $io;
    }

    public function deactivate(Composer $composer, IOInterface $io): void
    {
        //
    }

    public function uninstall(Composer $composer, IOInterface $io): void
    {
        //
    }

    public static function getSubscribedEvents(): array
    {
        return [
            PluginEvents::PRE_FILE_DOWNLOAD => [
                ['onPreFileDownload', 9999],
            ],
        ];
    }

    public function onPreFileDownload(PreFileDownloadEvent $event): void
    {
        $processedUrl = $event->getProcessedUrl();

        var_dump($event);
        $this->io->debug('PreFileDownloadEvent');
        $this->io->debug('Name: ' . $event->getName());
        $this->io->debug('Processed URL: ' . $event->getProcessedUrl());
        $this->io->debug('New Processed URL: ' . $processedUrl . '?id=' . gethostname());

        // Modifying this code is against the product license. Just buy the dang thing and save yourself the effort.
        $event->setProcessedUrl($processedUrl . '?id=' . gethostname());
    }
}